<?php

namespace ElementPack\Modules\FacebookFeed\Widgets;

use Elementor\Controls_Manager;
use ElementPack\Base\Module_Base;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Exit if accessed directly

class Facebook_Feed extends Module_Base {

	public $feed_data = [];
	public $api_url = 'https://graph.facebook.com/v4.0/%1$s/posts?%2$s&access_token=%3$s';
	public $api_queries = 'fields=status_type,created_time,from,message,story,full_picture,permalink_url,attachments.limit(1){type,media_type,title,description,unshimmed_url},comments.summary(total_count),reactions.summary(total_count)';

	public function get_name() {
		return 'bdt-facebook-feed';
	}

	public function get_title() {
		return BDTEP . esc_html__( 'Facebook Feed', 'bdthemes-element-pack' );
	}

	public function get_icon() {
		return 'bdt-wi-facebook-feed';
	}

	public function get_categories() {
		return [ 'element-pack' ];
	}

	public function get_keywords() {
		return [ 'facebook', 'feed' ];
	}

	public function get_style_depends() {
		if ( $this->ep_is_edit_mode() ) {
			return [ 'ep-styles' ];
		} else {
			return [ 'ep-facebook-feed' ];
		}
	}

	// public function get_custom_help_url() {
	//     return 'https://youtu.be/m38ddVi52-Q';
	// }

	protected function register_controls() {
		$this->start_controls_section(
			'section_content_air_pollution',
			[ 
				'label' => esc_html__( 'Facebook Feed', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'select_api_type',
			[ 
				'label'       => esc_html__( 'Select API', 'bdthemes-element-pack' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'global',
				'options'     => [ 
					'custom' => esc_html__( 'Custom', 'bdthemes-element-pack' ),
					'global' => esc_html__( 'Global', 'bdthemes-element-pack' ),
				],
				'render_type' => 'template',
			]
		);


		$this->add_control(
			'api_page_id',
			[ 
				'label'       => esc_html__( 'Page ID', 'bdthemes-element-pack' ),
				'description' => esc_html__( 'A Facebook page ID is a unique identifier assigned to each Facebook page. It can be used to access information about the page, such as its name, profile picture, and cover photo, as well as to interact with the page\'s content and followers.', 'bdthemes-element-pack' ) . sprintf( '<br> Link - <a href="https://developers.facebook.com/apps/" target="blank">Get Page ID</a>' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [ 'active' => true ],
				'condition'   => [ 
					'select_api_type' => 'custom'
				]
			]
		);

		$this->add_control(
			'api_access_token',
			[ 
				'label'       => esc_html__( 'Access Token', 'bdthemes-element-pack' ),
				'description' => esc_html__( 'A Facebook page access token is a string of characters that is generated by Facebook and is used to grant an app or server access to a specific Facebook page.', 'bdthemes-element-pack' ) . sprintf( '<br> Link - <a href="https://developers.facebook.com/apps/" target="blank">Get Access Token</a>' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [ 'active' => true ],
				'condition'   => [ 
					'select_api_type' => 'custom'
				]
			]
		);

		$this->add_control(
			'data_cache',
			[ 
				'label'       => esc_html__( 'Cache Feeds', 'bdthemes-element-pack' ),
				'type'        => Controls_Manager::SWITCHER,
				'default'     => 'yes',
				'description' => esc_html__( 'Note:- Please use this cache option to reduce your request of API Calls.', 'bdthemes-element-pack' ),
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'cache_refresh',
			[ 
				'label'     => esc_html__( 'Reload Cache after ', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '12',
				'options'   => array(
					'30'  => esc_html__( '30 Minutes', 'bdthemes-element-pack' ),
					'1'   => esc_html__( '1 Hour', 'bdthemes-element-pack' ),
					'3'   => esc_html__( '3 Hour', 'bdthemes-element-pack' ),
					'6'   => esc_html__( '6 Hour', 'bdthemes-element-pack' ),
					'12'  => esc_html__( '12 Hour', 'bdthemes-element-pack' ),
					'24'  => esc_html__( '24 Hour', 'bdthemes-element-pack' ),
					'7d'  => esc_html__( '7 Days', 'bdthemes-element-pack' ),
					'15d' => esc_html__( '15 Days', 'bdthemes-element-pack' ),
					'30d' => esc_html__( '30 Days', 'bdthemes-element-pack' ),
				),
				'condition' => [ 
					'data_cache' => 'yes',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_additional',
			[ 
				'label' => esc_html__( 'Additional', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'masonry',
			[ 
				'label'        => __( 'Masonry', 'pixel-gallery' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'prefix_class' => 'bdt-ep-masonry--',
				'render_type'  => 'template'
			]
		);

		$this->add_responsive_control(
			'columns',
			[ 
				'label'          => __( 'Columns', 'ultimate-post-kit' ),
				'type'           => Controls_Manager::SELECT,
				'default'        => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options'        => [ 
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'selectors'      => [ 
					'{{WRAPPER}} .bdt-grid-wrap' => 'columns: {{SIZE}}; display: block;'
				],
				'condition'      => [ 
					'masonry' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'grid_columns',
			[ 
				'label'          => __( 'Columns', 'ultimate-post-kit' ),
				'type'           => Controls_Manager::SELECT,
				'default'        => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options'        => [ 
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'selectors'      => [ 
					'{{WRAPPER}} .bdt-grid-wrap' => 'grid-template-columns: repeat({{SIZE}}, 1fr); display: grid;',
				],
				'condition'      => [ 
					'masonry' => ''
				]
			]
		);


		$this->add_responsive_control(
			'row_gap',
			[ 
				'label'     => esc_html__( 'Row Gap', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => [ 
					'size' => 20,
				],
				'selectors' => [ 
					'{{WRAPPER}} .bdt-grid-wrap'                                        => 'grid-row-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}.bdt-ep-masonry--yes .bdt-facebook-feed-wrap .bdt-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'column_gap',
			[ 
				'label'     => esc_html__( 'Column Gap', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => [ 
					'size' => 20,
				],
				'selectors' => [ 
					'{{WRAPPER}} .bdt-grid-wrap' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->add_control(
			'layout_style',
			[ 
				'label'   => __( 'Layout Style', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [ 
					'style-1' => '1',
					'style-2' => '2',
				],
				'default' => 'style-1',
			]
		);


		$this->add_control(
			'show_desc',
			[ 
				'label'     => esc_html__( 'Show Text', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'desc_word_count',
			[ 
				'label'     => esc_html__( 'Text Word Count', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::NUMBER,
				'min'       => 0,
				'max'       => 500,
				'default'   => 15,
				'condition' => [ 
					'show_desc' => 'yes'
				]
			]
		);

		$this->add_control(
			'show_feature_image',
			[ 
				'label'   => esc_html__( 'Show Feature Image', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_author_image',
			[ 
				'label'   => esc_html__( 'Show Author Image', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_author_name',
			[ 
				'label'   => esc_html__( 'Show Author Name', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_date',
			[ 
				'label'   => esc_html__( 'Show Date', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_like',
			[ 
				'label'   => esc_html__( 'Show Like', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_comments',
			[ 
				'label'   => esc_html__( 'Show Comments', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_read_more',
			[ 
				'label'   => esc_html__( 'Show Read More', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_share',
			[ 
				'label'   => esc_html__( 'Show Share', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'read_more_text',
			[ 
				'label'   => esc_html__( 'Read More Text', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'See More',
			]
		);

		$this->add_control(
			'link_target',
			[ 
				'label'     => esc_html__( 'Link Target', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [ 
					'_self'  => esc_html__( 'Open in same window', 'bdthemes-element-pack' ),
					'_blank' => esc_html__( 'Open in new window', 'bdthemes-element-pack' ),
				],
				'default'   => '_blank',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'post_limit',
			[ 
				'label'   => esc_html__( 'Post Limit', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_item_style',
			[ 
				'label' => esc_html__( 'Item', 'bdthemes-element-pack' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_item_style' );

		$this->start_controls_tab(
			'tab_item_normal',
			[ 
				'label' => esc_html__( 'Normal', 'bdthemes-element-pack' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'item_background',
				'selector' => '{{WRAPPER}} .bdt-item',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[ 
				'name'      => 'item_border',
				'selector'  => '{{WRAPPER}} .bdt-item',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'item_border_radius',
			[ 
				'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'item_padding',
			[ 
				'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [ 
					'layout_style' => 'style-2'
				]
			]
		);

		$this->add_responsive_control(
			'content_padding',
			[ 
				'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-fb-style-1 .bdt-fb-content'         => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bdt-fb-style-1 .bdt-share-and-readmore' => 'padding: 0 {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};',
				],
				'condition'  => [ 
					'layout_style' => 'style-1'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .bdt-item',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_item_hover',
			[ 
				'label' => esc_html__( 'Hover', 'bdthemes-element-pack' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'item_hover_background',
				'selector' => '{{WRAPPER}} .bdt-item:hover',
			]
		);

		$this->add_control(
			'item_hover_border_color',
			[ 
				'label'     => esc_html__( 'Border Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [ 
					'item_border_border!' => '',
				],
				'selectors' => [ 
					'{{WRAPPER}} .bdt-item:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'item_hover_box_shadow',
				'selector' => '{{WRAPPER}} .bdt-item:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_author_style',
			[ 
				'label' => esc_html__( 'Author', 'bdthemes-element-pack' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'author_name',
			[ 
				'label' => esc_html__( 'N A M E', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::HEADING,
			]
		);

		$this->start_controls_tabs(
			'style_name_tabs'
		);

		$this->start_controls_tab(
			'name_tab_normal',
			[ 
				'label' => esc_html__( 'Normal', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'author_color',
			[ 
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-author-name' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[ 
				'name'     => 'author_typography',
				'selector' => '{{WRAPPER}} .bdt-author-name',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[ 
				'name'     => 'author_text_shadow',
				'label'    => esc_html__( 'Text Shadow', 'bdthemes-element-pack' ),
				'selector' => '{{WRAPPER}} .bdt-author-name',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'name_tab_hover',
			[ 
				'label' => esc_html__( 'Hover', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'author_color_hover',
			[ 
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-author-name:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[ 
				'name'     => 'author_text_shadow_hover',
				'label'    => esc_html__( 'Text Shadow', 'bdthemes-element-pack' ),
				'selector' => '{{WRAPPER}} .bdt-author-name:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'author_img',
			[ 
				'label'     => esc_html__( 'I M A G E', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'author_img_size',
			[ 
				'label'     => esc_html__( 'Size', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [ 
					'px' => [ 
						'min' => 30,
						'max' => 100,
					],
				],
				'selectors' => [ 
					'{{WRAPPER}} .bdt-icon-img' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'author_img_padding',
			[ 
				'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-icon-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[ 
				'name'        => 'author_img_border',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .bdt-icon-img',
			]
		);

		$this->add_responsive_control(
			'author_img_radius',
			[ 
				'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-icon-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'author_img_background',
				'selector' => '{{WRAPPER}} .bdt-icon-img',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'author_img_shadow',
				'selector' => '{{WRAPPER}} .bdt-icon-img',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_date',
			[ 
				'label'     => esc_html__( 'Date', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [ 
					'show_date' => 'yes'
				]
			]
		);

		$this->add_control(
			'date_color',
			[ 
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-date-muted' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[ 
				'name'     => 'date_typography',
				'selector' => '{{WRAPPER}} .bdt-date-muted',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[ 
				'name'     => 'date_text_shadow',
				'label'    => esc_html__( 'Text Shadow', 'bdthemes-element-pack' ),
				'selector' => '{{WRAPPER}} .bdt-date-muted',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_description',
			[ 
				'label' => esc_html__( 'Text', 'bdthemes-element-pack' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'desc_color',
			[ 
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_margin',
			[ 
				'label'      => esc_html__( 'Margin', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[ 
				'name'     => 'desc_typography',
				'selector' => '{{WRAPPER}} .bdt-text',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[ 
				'name'     => 'desc_text_shadow',
				'label'    => esc_html__( 'Text Shadow', 'bdthemes-element-pack' ),
				'selector' => '{{WRAPPER}} .bdt-text',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_feature_image',
			[ 
				'label'     => esc_html__( 'Feature Image', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [ 
					'show_feature_image' => 'yes'
				]
			]
		);


		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'feature_img_background',
				'selector' => '{{WRAPPER}} .bdt-img-wrap img',
			]
		);


		$this->add_group_control(
			Group_Control_Border::get_type(),
			[ 
				'name'        => 'feature_img_border',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .bdt-img-wrap img',
			]
		);

		$this->add_responsive_control(
			'feature_img_radius',
			[ 
				'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-img-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
				],
			]
		);

		$this->add_responsive_control(
			'feature_img_padding',
			[ 
				'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-img-wrap img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'feature_img_margin',
			[ 
				'label'      => esc_html__( 'Margin', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-img-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'feature_img_shadow',
				'selector' => '{{WRAPPER}} .bdt-img-wrap img',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_read_more',
			[ 
				'label'     => esc_html__( 'Read More', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [ 
					'show_read_more' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'readmore_spacing',
			[ 
				'label'     => esc_html__( 'Spacing', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-share-and-readmore' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs(
			'style_read_more_tabs'
		);

		$this->start_controls_tab(
			'read_more_normal',
			[ 
				'label' => esc_html__( 'Normal', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'read_more_color',
			[ 
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-read-more a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[ 
				'name'     => 'read_more_typography',
				'selector' => '{{WRAPPER}} .bdt-read-more a',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[ 
				'name'     => 'read_more_text_shadow',
				'label'    => esc_html__( 'Text Shadow', 'bdthemes-element-pack' ),
				'selector' => '{{WRAPPER}} .bdt-read-more a',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'read_more_hover',
			[ 
				'label' => esc_html__( 'Hover', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'read_more_color_hover',
			[ 
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-read-more a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[ 
				'name'     => 'read_more_text_shadow_hover',
				'label'    => esc_html__( 'Text Shadow', 'bdthemes-element-pack' ),
				'selector' => '{{WRAPPER}} .bdt-read-more:hover a',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();


		$this->start_controls_section(
			'section_social_button',
			[ 
				'label' => esc_html__( 'Like/Comments', 'bdthemes-element-pack' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'like_comments_button_margin',
			[ 
				'label'      => __( 'Margin', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'like_comments_button_spacing_gap',
			[ 
				'label'     => esc_html__( 'Spacing', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs(
			'like_comments_button_style_tabs'
		);

		$this->start_controls_tab(
			'like_button_style_tab',
			[ 
				'label'     => __( 'Like', 'bdthemes-element-pack' ),
				'condition' => [ 
					'show_like' => 'yes'
				]
			]
		);


		$this->add_control(
			'like_button_text_color',
			[ 
				'label'     => __( 'Text Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'like_button_background',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[ 
				'name'     => 'like_button_border',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon'
			]
		);

		$this->add_responsive_control(
			'like_button_radius',
			[ 
				'label'      => __( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'like_button_shadow',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon',
			]
		);

		$this->add_responsive_control(
			'like_button_padding',
			[ 
				'label'      => __( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[ 
				'name'     => 'like_button_typography',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon .bdt-count',
			]
		);

		$this->add_responsive_control(
			'like_icon_size_gap',
			[ 
				'label'     => esc_html__( 'Icon Size', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'like_spacing_gap',
			[ 
				'label'     => esc_html__( 'Spacing', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'like_button_hover_options',
			[ 
				'label'     => esc_html__( 'HOVER', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'like_button_hover_text_color',
			[ 
				'label'     => __( 'Text Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'like_button_hover_background',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon:hover',
			]
		);

		$this->add_control(
			'like_button_hover_border_color',
			[ 
				'label'     => __( 'Border Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon:hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [ 
					'like_button_border_border!' => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'like_button_hover_shadow',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-like-icon:hover',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'comments_button_style_hover_tab',
			[ 
				'label'     => __( 'Comments', 'bdthemes-element-pack' ),
				'condition' => [ 
					'show_comments' => 'yes'
				]
			]
		);

		$this->add_control(
			'commenting_button_text_color',
			[ 
				'label'     => __( 'Text Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'commenting_button_background',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[ 
				'name'     => 'commenting_button_border',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon'
			]
		);

		$this->add_responsive_control(
			'commenting_button_radius',
			[ 
				'label'      => __( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'commenting_button_shadow',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon',
			]
		);

		$this->add_responsive_control(
			'commenting_button_padding',
			[ 
				'label'      => __( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[ 
				'name'     => 'commenting_button_typography',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon .bdt-count',
			]
		);

		$this->add_responsive_control(
			'commenting_icon_size_gap',
			[ 
				'label'     => esc_html__( 'Icon Size', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'commenting_spacing_gap',
			[ 
				'label'     => esc_html__( 'Spacing', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'commenting_button_hover_options',
			[ 
				'label'     => esc_html__( 'HOVER', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'commenting_button_hover_text_color',
			[ 
				'label'     => __( 'Text Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'commenting_button_hover_background',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon:hover',
			]
		);

		$this->add_control(
			'commenting_button_hover_border_color',
			[ 
				'label'     => __( 'Border Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon:hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [ 
					'commenting_button_border_border!' => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'commenting_button_hover_shadow',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-social-button .bdt-commenting-icon:hover',
			]
		);


		$this->end_controls_tab();

		$this->end_controls_tabs();


		$this->end_controls_section();

		$this->start_controls_section(
			'section_share_button',
			[ 
				'label'     => esc_html__( 'Share', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [ 
					'show_share' => 'yes'
				]
			]
		);

		$this->start_controls_tabs(
			'share_button_style_tabs'
		);

		$this->start_controls_tab(
			'share_button_normal_tab',
			[ 
				'label' => __( 'Share', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'share_button_text_color',
			[ 
				'label'     => __( 'Text Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'share_button_background',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[ 
				'name'     => 'share_button_border',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon'
			]
		);

		$this->add_responsive_control(
			'share_button_radius',
			[ 
				'label'      => __( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);



		$this->add_responsive_control(
			'share_button_padding',
			[ 
				'label'      => __( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'share_button_margin',
			[ 
				'label'      => __( 'Margin', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-share-btn-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[ 
				'name'     => 'share_button_typography',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon .bdt-count',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'share_button_shadow',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon',
			]
		);

		$this->add_responsive_control(
			'share_button_icon_font_size',
			[ 
				'label'     => esc_html__( 'Icon Size', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->add_control(
			'share_button_hover_name',
			[ 
				'label'     => esc_html__( 'H O V R R', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'share_button_hover_text_color',
			[ 
				'label'     => __( 'Text Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'share_button_hover_background',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon:hover',
			]
		);

		$this->add_control(
			'share_button_hover_border_color',
			[ 
				'label'     => __( 'Border Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon:hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [ 
					'share_button_border_border!' => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'share_button_hover_shadow',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-share-icon:hover',
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'share_button_dropdown_style_hover_tab',
			[ 
				'label' => __( 'Dropdown', 'bdthemes-element-pack' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[ 
				'name'     => 'share_button_drop_background',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[ 
				'name'     => 'share_button_drop_border',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown'
			]
		);

		$this->add_responsive_control(
			'share_button_drop_radius',
			[ 
				'label'      => __( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->add_responsive_control(
			'share_button_drop_padding',
			[ 
				'label'      => __( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[ 
				'name'     => 'share_button_drop_shadow',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown',
			]
		);

		$this->add_control(
			'share_button_drop_title_name',
			[ 
				'label'     => esc_html__( 'T I T L E', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);


		$this->add_control(
			'share_button_drop_title_color',
			[ 
				'label'     => __( 'Text Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[ 
				'name'     => 'share_button_drop_title_typography',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown-title',
			]
		);

		$this->add_responsive_control(
			'share_button_drop_title_margin',
			[ 
				'label'      => __( 'Margin', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'share_button_drop_menu_name',
			[ 
				'label'     => esc_html__( 'L I S T', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'share_button_drop_text_color',
			[ 
				'label'     => __( 'Text Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'share_button_drop_text_hover_color',
			[ 
				'label'     => __( 'Text Hover Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[ 
				'name'     => 'share_button_drop_text_typography',
				'selector' => '{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown a',
			]
		);


		$this->add_responsive_control(
			'share_button_drop_text_spacing',
			[ 
				'label'     => esc_html__( 'Spacing', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [ 
					'{{WRAPPER}} .bdt-facebook-feed-wrap .bdt-dropdown-nav' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_tab();

		$this->end_controls_tabs();


		$this->end_controls_section();
	}

	protected function render_read_more( $data ) {
		$settings = $this->get_settings_for_display();
		if ( 'yes' !== $settings['show_read_more'] && ! empty( $settings['read_more_text'] ) ) {
			return;
		}
		printf(
			'<div class="bdt-read-more"><a href="%1$s" target="%2$s">%3$s
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="one bi bi-arrow-right" viewBox="0 0 16 16">
            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
           </svg>
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="two bi bi-arrow-right" viewBox="0 0 16 16">
            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
          </svg>
            </a></div>',
			esc_url( $data['permalink_url'] ),
			esc_attr( $settings['link_target'] ),
			esc_html( $settings['read_more_text'] )
		);
	}

	protected function render_main_share( $data ) {
		$settings = $this->get_settings_for_display();
		if ( 'yes' !== $settings['show_share'] ) {
			return;
		}

		?>
		<div class="bdt-share-btn-wrap">
			<div class="bdt-share-icon" type="button">
				<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-share-fill"
					viewBox="0 0 16 16">
					<path
						d="M11 2.5a2.5 2.5 0 1 1 .603 1.628l-6.718 3.12a2.499 2.499 0 0 1 0 1.504l6.718 3.12a2.5 2.5 0 1 1-.488.876l-6.718-3.12a2.5 2.5 0 1 1 0-3.256l6.718-3.12A2.5 2.5 0 0 1 11 2.5z" />
				</svg>
			</div>
			<div bdt-dropdown="pos: top-right">
				<ul class="bdt-nav bdt-dropdown-nav">
					<li class="bdt-dropdown-title">
						<?php esc_html_e( 'share on', 'bdthemes-element-pack' ) ?>
					</li>
					<?php
					printf(
						'<li>
                            <a href="https://www.facebook.com/sharer/sharer.php?u=%1$s" target="%2$s">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                                    <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951z" />
                                </svg>
                                <span>%3$s</span>
                            </a>
                        </li>',
						esc_url( $data['permalink_url'] ),
						esc_attr( $settings['link_target'] ),
						esc_html__( 'Facebook', 'bdthemes-element-pack' )
					);
					printf(
						'<li>
                            <a href="https://twitter.com/intent/tweet?url=%1$s" target="%2$s">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-twitter" viewBox="0 0 16 16">
                                    <path d="M5.026 15c6.038 0 9.341-5.003 9.341-9.334 0-.14 0-.282-.006-.422A6.685 6.685 0 0 0 16 3.542a6.658 6.658 0 0 1-1.889.518 3.301 3.301 0 0 0 1.447-1.817 6.533 6.533 0 0 1-2.087.793A3.286 3.286 0 0 0 7.875 6.03a9.325 9.325 0 0 1-6.767-3.429 3.289 3.289 0 0 0 1.018 4.382A3.323 3.323 0 0 1 .64 6.575v.045a3.288 3.288 0 0 0 2.632 3.218 3.203 3.203 0 0 1-.865.115 3.23 3.23 0 0 1-.614-.057 3.283 3.283 0 0 0 3.067 2.277A6.588 6.588 0 0 1 .78 13.58a6.32 6.32 0 0 1-.78-.045A9.344 9.344 0 0 0 5.026 15z" />
                                </svg>
                                <span>%3$s</span></a>
                            </a>
                        </li>',
						esc_url( $data['permalink_url'] ),
						esc_attr( $settings['link_target'] ),
						esc_html__( 'Twitter', 'bdthemes-element-pack' )
					);
					printf(
						'<li>
                            <a href="https://pinterest.com/pin/create/button/?url=%1$s" target="%2$s">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pinterest" viewBox="0 0 16 16">
                                    <path d="M8 0a8 8 0 0 0-2.915 15.452c-.07-.633-.134-1.606.027-2.297.146-.625.938-3.977.938-3.977s-.239-.479-.239-1.187c0-1.113.645-1.943 1.448-1.943.682 0 1.012.512 1.012 1.127 0 .686-.437 1.712-.663 2.663-.188.796.4 1.446 1.185 1.446 1.422 0 2.515-1.5 2.515-3.664 0-1.915-1.377-3.254-3.342-3.254-2.276 0-3.612 1.707-3.612 3.471 0 .688.265 1.425.595 1.826a.24.24 0 0 1 .056.23c-.061.252-.196.796-.222.907-.035.146-.116.177-.268.107-1-.465-1.624-1.926-1.624-3.1 0-2.523 1.834-4.84 5.286-4.84 2.775 0 4.932 1.977 4.932 4.62 0 2.757-1.739 4.976-4.151 4.976-.811 0-1.573-.421-1.834-.919l-.498 1.902c-.181.695-.669 1.566-.995 2.097A8 8 0 1 0 8 0z" />
                                </svg>
                                <span>%3$s</span></a>
                            </a>
                        </li>',
						esc_url( $data['permalink_url'] ),
						esc_attr( $settings['link_target'] ),
						esc_html__( 'Pinterest', 'bdthemes-element-pack' )
					);
					?>

				</ul>
			</div>
		</div>
		<?php
	}

	protected function render_date( $data ) {
		$settings = $this->get_settings_for_display();
		if ( 'yes' !== $settings['show_date'] ) {
			return;
		}
		printf(
			'<div class="bdt-date-muted">%1$s</div>',
			esc_html( date( "M d Y", strtotime( $data['created_time'] ) ) )
		);
	}

	protected function render_author_image( $data ) {
		$settings = $this->get_settings_for_display();
		if ( 'yes' !== $settings['show_author_image'] ) {
			return;
		}
		$page_url   = "https://facebook.com/{$data['from']['id']}";
		$avatar_url = "https://graph.facebook.com/v4.0/{$data['from']['id']}/picture";
		printf(
			'<a href="%1$s" target="%2$s" class="bdt-icon-img-wrap"><img class="bdt-icon-img" src="%3$s" alt="%4$s"></a>',
			esc_url( $page_url ),
			esc_attr( $settings['link_target'] ),
			esc_url( $avatar_url ),
			esc_html( $data['from']['name'] )
		);
	}

	protected function render_author_name( $data ) {
		$settings = $this->get_settings_for_display();
		if ( 'yes' !== $settings['show_author_name'] ) {
			return;
		}

		$page_url = "https://facebook.com/{$data['from']['id']}";

		printf(
			'<div class="bdt-user-content"><a class="bdt-author-name" href="%1$s" target="%2$s">%3$s</a></div>',
			esc_url( $page_url ),
			esc_attr( $settings['link_target'] ),
			esc_html( $data['from']['name'] )
		);
	}

	protected function render_feature_image( $data ) {
		$settings = $this->get_settings_for_display();

		if ( 'yes' !== $settings['show_feature_image'] || empty( $data['full_picture'] ) ) {
			return;
		}
		printf(
			'<div class="bdt-img-wrap"><a href="%1$s" target="%2$s"><img src="%3$s" alt="%4$s"></a></div>',
			esc_url( $data['permalink_url'] ),
			esc_attr( $settings['link_target'] ),
			esc_url( $data['full_picture'] ),
			esc_html( $data['from']['name'] )
		);
	}

	protected function render_desc( $data ) {
		$settings = $this->get_settings_for_display();

		if ( 'yes' !== $settings['show_desc'] ) {
			return;
		}

		$description = ! empty( $data['message'] ) ? explode( ' ', $data['message'] ) : [];

		if ( ! empty( $settings['desc_word_count'] ) && count( $description ) > $settings['desc_word_count'] ) {
			$srt = array_slice( $description, 0, $settings['desc_word_count'] );
			printf( '<div class="bdt-text">%1$s</div>', wp_kses_post( implode( ' ', $srt ) ) . '...' );
			return;
		}

		printf( '<div class="bdt-text">%1$s</div>', ! empty( $data['message'] ) ? wp_kses_post( $data['message'] ) : '' );
	}

	protected function render_like( $data ) {
		$settings = $this->get_settings_for_display();
		if ( 'yes' !== $settings['show_like'] ) {
			return;
		}

		printf(
			'<a class="bdt-like-icon" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-hand-thumbs-up-fill" viewBox="0 0 16 16">
                <path d="M6.956 1.745C7.021.81 7.908.087 8.864.325l.261.066c.463.116.874.456 1.012.965.22.816.533 2.511.062 4.51a9.84 9.84 0 0 1 .443-.051c.713-.065 1.669-.072 2.516.21.518.173.994.681 1.2 1.273.184.532.16 1.162-.234 1.733.058.119.103.242.138.363.077.27.113.567.113.856 0 .289-.036.586-.113.856-.039.135-.09.273-.16.404.169.387.107.819-.003 1.148a3.163 3.163 0 0 1-.488.901c.054.152.076.312.076.465 0 .305-.089.625-.253.912C13.1 15.522 12.437 16 11.5 16H8c-.605 0-1.07-.081-1.466-.218a4.82 4.82 0 0 1-.97-.484l-.048-.03c-.504-.307-.999-.609-2.068-.722C2.682 14.464 2 13.846 2 13V9c0-.85.685-1.432 1.357-1.615.849-.232 1.574-.787 2.132-1.41.56-.627.914-1.28 1.039-1.639.199-.575.356-1.539.428-2.59z"/>
                </svg>
                <span class="bdt-count">%1$s</span>
        </a>',
			esc_html( $data['reactions']['summary']['total_count'] )
		);
	}

	protected function render_comments( $data ) {
		$settings = $this->get_settings_for_display();
		if ( 'yes' !== $settings['show_comments'] ) {
			return;
		}

		printf(
			'<a class="bdt-commenting-icon" href="#">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chat-left-fill" viewBox="0 0 16 16">
                <path d="M2 0a2 2 0 0 0-2 2v12.793a.5.5 0 0 0 .854.353l2.853-2.853A1 1 0 0 1 4.414 12H14a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2z"/>
                </svg>
                <span class="bdt-count">%1$s</span>
            </a>',
			esc_html( $data['comments']['summary']['total_count'] )
		);
	}

	public function get_transient_expire( $settings ) {
		$expire_value = $settings['cache_refresh'];
		$expire_time  = 1 * HOUR_IN_SECONDS;

		if ( '1' === $expire_value ) {
			$expire_time = 1 * HOUR_IN_SECONDS;
		} elseif ( '3' === $expire_value ) {
			$expire_time = 3 * HOUR_IN_SECONDS;
		} elseif ( '6' === $expire_value ) {
			$expire_time = 6 * HOUR_IN_SECONDS;
		} elseif ( '12' === $expire_value ) {
			$expire_time = 12 * HOUR_IN_SECONDS;
		} elseif ( '24' === $expire_value ) {
			$expire_time = 24 * HOUR_IN_SECONDS;
		} elseif ( '15' === $expire_value ) {
			$expire_time = 15 * MINUTE_IN_SECONDS;
		} elseif ( '30' === $expire_value ) {
			$expire_time = 30 * MINUTE_IN_SECONDS;
		} elseif ( '7d' === $expire_value ) {
			$expire_time = 7 * DAY_IN_SECONDS;
		} elseif ( '15d' === $expire_value ) {
			$expire_time = 15 * DAY_IN_SECONDS;
		} elseif ( '30d' === $expire_value ) {
			$expire_time = 30 * DAY_IN_SECONDS;
		}

		return $expire_time;
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->feed_data = $this->feed_data();
		$data            = $this->feed_data;

		if ( false === $data ) {
			return;
		}

		$post_limit = ! empty( $settings['post_limit'] ) ? $settings['post_limit'] : 6;
		$items      = array_splice( $data, 0, $post_limit );

		$this->add_render_attribute( 'facebook-feed', 'class', 'bdt-facebook-feed-wrap bdt-fb-' . $settings['layout_style'] . '' );

		?>

		<div <?php $this->print_render_attribute_string( 'facebook-feed' ); ?>>
			<div class="bdt-grid-wrap">
				<?php foreach ( $items as $item ) : ?>
					<div class="bdt-item">
						<div class="bdt-content">
							<div class="bdt-fb-content">
								<div class="bdt-inner-content">
									<div class="bdt-author-wrap">
										<?php
										/**
										 * Render Feature Image
										 */
										$this->render_author_image( $item );
										?>
										<div>
											<?php $this->render_author_name( $item ); ?>
											<?php $this->render_date( $item ); ?>
										</div>
									</div>

									<?php
									/**
									 * Render Like & Comments
									 */
									if ( 'yes' == $settings['show_like'] || 'yes' == $settings['show_comments'] ) {
										printf( '<div class="bdt-social-button">' );
									}

									$this->render_like( $item );
									$this->render_comments( $item );

									if ( 'yes' == $settings['show_like'] || 'yes' == $settings['show_comments'] ) {
										printf( '</div>' );
									}
									?>

								</div>
								<?php $this->render_desc( $item ); ?>
							</div>
							<div class="bdt-img-content">

								<?php
								/**
								 * Render Read More & Share
								 */

								if ( 'yes' == $settings['show_read_more'] || 'yes' == $settings['show_share'] ) {
									printf( '<div class="bdt-share-and-readmore">' );
								}

								$this->render_read_more( $item );
								$this->render_main_share( $item );

								if ( 'yes' == $settings['show_read_more'] || 'yes' == $settings['show_share'] ) {
									printf( '</div>' );
								}


								?>
								<?php $this->render_feature_image( $item ); ?>
							</div>
						</div>

					</div>
				<?php endforeach; ?>
			</div>
		</div>

		<?php
	}

	public function feed_data() {
		$settings        = $this->get_settings_for_display();
		$ep_api_settings = get_option( 'element_pack_api_settings' );
		$fb_page_id      = ! empty( $ep_api_settings['fb_page_id'] ) ? $ep_api_settings['fb_page_id'] : '';
		$fb_access_token = ! empty( $ep_api_settings['fb_access_token'] ) ? $ep_api_settings['fb_access_token'] : '';

		/**
		 * Override If Custom Yes
		 */
		if ( 'custom' == $settings['select_api_type'] ) {
			$fb_page_id      = $settings['api_page_id'];
			$fb_access_token = $settings['api_access_token'];
		}

		if ( ! $fb_page_id || ! $fb_access_token ) {
			$message = esc_html__( 'Ops! I think you forget to set API key, please set your API key.', 'bdthemes-element-pack' );
			$this->_error_notice( $message );
			return false;
		}

		$id            = $fb_page_id;
		$transient_key = sprintf( 'bdt-facebook-feed-data-%s', md5( $id ) );

		if ( $settings['data_cache'] == 'yes' ) {
			$data = get_transient( $transient_key );
		} else {
			$data = '';
		}

		/**
		 * Transient Data Not Found
		 * Let's send a API request for data
		 */

		if ( ! $data ) {
			$request_url   = sprintf( $this->api_url, $fb_page_id, $this->api_queries, $fb_access_token );
			$raw_feed_data = $this->data_remote_request( $request_url );

			if ( ! $raw_feed_data ) {
				return false;
			}

			/**
			 * Check If any Error
			 */
			if ( ! empty( $raw_feed_data ) && array_key_exists( 'error', $raw_feed_data ) ) {
				if ( isset( $raw_feed_data['error']['message'] ) ) {
					$message = $raw_feed_data['error']['message'];
				} else {
					$message = esc_html__( 'Your API credentials are not correct.', 'bdthemes-element-pack' );
				}

				$this->_error_notice( $message );

				return false;
			}

			// print_r($raw_feed_data);

			$data = $this->transient_feed_data( $raw_feed_data );

			if ( empty( $data ) ) {
				return false;
			}

			$expireTime = $this->get_transient_expire( $settings );

			if ( $settings['data_cache'] == 'yes' ) {
				set_transient( $transient_key, $data, apply_filters( 'element-pack/facebook-feed/cached-time', $expireTime ) );
			}
			return $data;
		}

		return $data;
	}

	public function data_remote_request( $url ) {

		$response = wp_remote_get( $url, array( 'timeout' => 30 ) );

		if ( ! $response || is_wp_error( $response ) ) {
			return false;
		}

		$remote_data = wp_remote_retrieve_body( $response );

		if ( ! $remote_data || is_wp_error( $remote_data ) ) {
			return false;
		}

		$remote_data = json_decode( $remote_data, true );

		if ( empty( $remote_data ) ) {
			return false;
		}
		return $remote_data;
	}

	public function transient_feed_data( $raw_data = [] ) {
		return $raw_data['data'];
	}

	public function _error_notice( $message ) {
		?>
		<div class="bdt-alert-warning" data-bdt-alert>
			<a class="bdt-alert-close" data-bdt-close></a>
			<p>
				<?php echo esc_html( $message ); ?>
			</p>
		</div>
		<?php
	}
}
